﻿//////////////////////////////////////////////
// Namespace.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkScripts
{
	class Function ;
	class UserType ;
}

/// Includes ---------------------------------

// nkScripts
#include "../../Dll/DllDefines.h"

#include "../ScriptObjects/ScriptObjectReference.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkScripts
{
	class DLL_SCRIPTS_EXPORT Namespace
	{
		public :

			// Constructeur, destructeur
			Namespace (nkMemory::StringView name) noexcept ;
			virtual ~Namespace () ;

			// Getters
			nkMemory::StringView getName () const ;

			// Contrôles : Getters
			virtual Namespace* getNamespace (nkMemory::StringView name) const = 0 ;
			virtual UserType* getUserType (nkMemory::StringView name) const = 0 ;

			// Contrôles : Setters
			virtual void setVar (nkMemory::StringView name, bool value) = 0 ;
			virtual void setVar (nkMemory::StringView name, int value) = 0 ;
			virtual void setVar (nkMemory::StringView name, float value) = 0 ;
			virtual void setVar (nkMemory::StringView name, double value) = 0 ;
			void setVar (nkMemory::StringView name, const char* value) ;
			virtual void setVar (nkMemory::StringView name, nkMemory::StringView value) = 0 ;
			virtual void setVar (nkMemory::StringView name, const ScriptObjectReference& value) = 0 ;
			virtual void setObject (nkMemory::StringView name, nkMemory::StringView userTypeName, void* value) = 0 ;

			virtual Namespace* setNamespace (nkMemory::StringView name) = 0 ;
			virtual UserType* setUserType (nkMemory::StringView name) = 0 ;
			virtual Function* setFunc (nkMemory::StringView name) = 0 ;

			virtual void shutdown () = 0 ;
			virtual void reset () = 0 ;

		protected :

			// Nom interne
			nkMemory::String _name ;
	} ;
}